package edu.unl.consystlab.sudokuSolver.consistencyAlgorithms;

import java.util.LinkedList;
import java.util.List;

import edu.unl.consystlab.sudokuSolver.constraintProblem;
import edu.unl.consystlab.sudokuSolver.problemConstraint;
import edu.unl.consystlab.sudokuSolver.sudokuBoard;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class consistencyAlgorithm extends Thread {

	protected constraintProblem parentProblem;
	protected problemConstraint brokenConstraint;
	protected List variableReductions;
	protected boolean encounteredError;
    protected sudokuBoard ourBoard;
	
	public consistencyAlgorithm(constraintProblem newProblem, sudokuBoard board)
	{
		parentProblem = newProblem;
        ourBoard = board;
		brokenConstraint = null;
		variableReductions = new LinkedList();
		encounteredError = false;
	}
	
	//returns true if the algorithm succeeds, false otherwise.
	public abstract boolean runAlgorithm() throws InterruptedException;

	public void setBrokenConstraint(problemConstraint brokenConstraint) {
		this.brokenConstraint = brokenConstraint;
	}

	public problemConstraint getBrokenConstraint() {
		return brokenConstraint;
	}

	public void setVariableReductions(List variableReductions) {
		this.variableReductions = variableReductions;
	}

	public List getVariableReductions() {
		return variableReductions;
	}

	public void setEncounteredError(boolean encounteredError) {
		this.encounteredError = encounteredError;
	}

	public boolean isEncounteredError() {
		return encounteredError;
	}

    public void run()
	{
        try {
            System.out.println("Running...");
            runAlgorithm();
        } catch (InterruptedException ex) {
            System.out.println("We stopped...");
            return;
        }
		ourBoard.add_consistency_undo(this);
		ourBoard.repaint();
		return;
	}
	
	
}
